/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame.worlds;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.entities.creatures.Player;
import dev.codenmore.tilegame.entities.creatures.Player2;
import dev.codenmore.tilegame.tiles.Tile;
import dev.codenmore.tilegame.utils.Utils;
import java.awt.Graphics;

public class World {
    private Handler handler;
    private int width;
    private int height;
    private int spawnX;
    private int spawnY;
    private int spawnX2;
    private int spawnY2;
    private int spawnX3;
    private int spawnY3;
    private int spawnX4;
    private int spawnY4;
    private int[][] tiles;

    public World(Handler handler, String path) {
        this.handler = handler;
        this.loadWorld(path);
    }

    public void tick() {
    }

    public void render(Graphics g, Player player, Player2 player2) {
        int xStart = (int)Math.max(0.0f, this.handler.getGameCamera().getxOffset() / 64.0f);
        int xEnd = (int)Math.min((float)this.width, (this.handler.getGameCamera().getxOffset() + (float)this.handler.getWidth()) / 64.0f + 1.0f);
        int yStart = (int)Math.max(0.0f, this.handler.getGameCamera().getyOffset() / 64.0f);
        int yEnd = (int)Math.min((float)this.height, (this.handler.getGameCamera().getyOffset() + (float)this.handler.getHeight()) / 64.0f + 1.0f);
        int y = yStart;
        while (y < yEnd) {
            int x = xStart;
            while (x < xEnd) {
                this.getTile(x, y).render(g, (int)((float)(x * 64) - this.handler.getGameCamera().getxOffset()), (int)((float)(y * 64) - this.handler.getGameCamera().getyOffset()));
                ++x;
            }
            ++y;
        }
    }

    public Tile getTile(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return Tile.grassTile;
        }
        Tile t = Tile.tiles[this.tiles[x][y]];
        if (t == null) {
            return Tile.rockTile;
        }
        return t;
    }

    private void loadWorld(String path) {
        String file = Utils.loadFileAsString(path);
        String[] tokens = file.split("\\s+");
        this.width = Utils.parseInt(tokens[0]);
        this.height = Utils.parseInt(tokens[1]);
        this.spawnX = Utils.parseInt(tokens[2]);
        this.spawnY = Utils.parseInt(tokens[3]);
        this.spawnX2 = Utils.parseInt(tokens[4]);
        this.spawnY2 = Utils.parseInt(tokens[5]);
        this.spawnX3 = Utils.parseInt(tokens[6]);
        this.spawnY3 = Utils.parseInt(tokens[7]);
        this.spawnX4 = Utils.parseInt(tokens[8]);
        this.spawnY4 = Utils.parseInt(tokens[9]);
        this.tiles = new int[this.width][this.height];
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                this.tiles[x][y] = Utils.parseInt(tokens[x + y * this.width + 10]);
                ++x;
            }
            ++y;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public void setSpawnX(int spawnX) {
        this.spawnX = spawnX;
    }

    public int getSpawnY() {
        return this.spawnY;
    }

    public void setSpawnY(int spawnY) {
        this.spawnY = spawnY;
    }

    public int getSpawnX2() {
        return this.spawnX2;
    }

    public void setSpawnX2(int spawnX) {
        this.spawnX2 = spawnX;
    }

    public int getSpawnY2() {
        return this.spawnY2;
    }

    public int getSpawnX3() {
        return this.spawnX3;
    }

    public int getSpawnY3() {
        return this.spawnY3;
    }

    public int getSpawnX4() {
        return this.spawnX4;
    }

    public int getSpawnY4() {
        return this.spawnY4;
    }

    public void setSpawnY2(int spawnY) {
        this.spawnY2 = spawnY;
    }
}

